# AI dla gier wideo — zostań mistrzem Snake’a
# Szkolenie AI

# Importowanie bibliotek
from environment import Environment
from brain import Brain
from DQN import Dqn
import numpy as np
import matplotlib.pyplot as plt

# Definiowanie parametrów
memSize = 60000
batchSize = 32
learningRate = 0.0001
gamma = 0.9
nLastStates = 4

epsilon = 1.
epsilonDecayRate = 0.0002
minEpsilon = 0.05

filepathToSave = 'model2.h5'

# Tworzenie środowiska, mózgu i pamięci doświadczeń
env = Environment(0)
brain = Brain((env.nRows, env.nColumns, nLastStates), learningRate)
model = brain.model
dqn = Dqn(memSize, gamma)

# Tworzenie funkcji, która zainicjalizuje stany gry
def resetStates():
    currentState = np.zeros((1, env.nRows, env.nColumns, nLastStates))
    
    for i in range(nLastStates):
        currentState[:,:,:,i] = env.screenMap
    
    return currentState, currentState

# Uruchomienie głównej pętli
epoch = 0
scores = list()
maxNCollected = 0
nCollected = 0.
totNCollected = 0
while True:
    # Resetowanie środowiska i stanów gry
    env.reset()
    currentState, nextState = resetStates()
    epoch += 1
    gameOver = False
    
    # Rozpoczęcie drugiej pętli, w której gramy i uczymy naszą sztuczną inteligencję
    while not gameOver: 
        
        # Wybór akcji do zagrania
        if np.random.rand() < epsilon:
            action = np.random.randint(0, 4)
        else:
            qvalues = model.predict(currentState)[0]
            action = np.argmax(qvalues)
        
        # Aktualizacja środowiska
        state, reward, gameOver = env.step(action)
        
        # Dodanie nowej klatki gry do następnego stanu i usunięcie najstarszej klatki z następnego stanu
        state = np.reshape(state, (1, env.nRows, env.nColumns, 1))
        nextState = np.append(nextState, state, axis = 3)
        nextState = np.delete(nextState, 0, axis = 3)
        
        # Zapamiętywanie przejścia i szkolenie naszej sztucznej inteligencji
        dqn.remember([currentState, action, reward, nextState], gameOver)
        inputs, targets = dqn.get_batch(model, batchSize)
        model.train_on_batch(inputs, targets)
        
        # Sprawdzenie, czy zebraliśmy jabłko, i aktualizacja obecnego stanu
        if env.collected:
            nCollected += 1
        
        currentState = nextState
    
    # Sprawdzenie, czy rekord jabłek zjedzonych w rundzie został pobity, a jeśli tak - zapisanie modelu
    if nCollected > maxNCollected and nCollected > 2:
        maxNCollected = nCollected
        model.save(filepathToSave)
    
    totNCollected += nCollected
    nCollected = 0
    
    # Wyświetlanie wyników co 100 gier
    if epoch % 100 == 0 and epoch != 0:
        scores.append(totNCollected / 100)
        totNCollected = 0
        plt.plot(scores)
        plt.xlabel('Epoch / 100')
        plt.ylabel('Average Score')
        plt.savefig('stats.png')
        plt.close()
    
    # Zmniejszenie wartości epsilon
    if epsilon > minEpsilon:
        epsilon -= epsilonDecayRate
    
    # Wyświetlanie wyników każdej gry
    print('Epoch: ' + str(epoch) + ' Current Best: ' + str(maxNCollected) + ' Epsilon: {:.5f}'.format(epsilon))
